<?php
include('nav.php');

 

?> 
 <style>
 /* ===== ADMIN DASHBOARD ===== */

.admin-dashboard {
    background: #f5f7fb;
    min-height: 100vh;
}

/* Header */
.dashboard-header h2 {
    font-size: 26px;
}

.bg-primary-soft {
    background: rgba(13,110,253,.12);
}

/* Dashboard Cards */
.dashboard-card {
    display: block;
    text-decoration: none;
    border-radius: 18px;
    transition: all .3s ease;
    height: 100%;
}

.dashboard-card .card-body {
    display: flex;
    gap: 18px;
    padding: 26px;
    align-items: center;
}

/* Hover effect */
.dashboard-card:hover {
    transform: translateY(-6px);
    box-shadow: 0 18px 40px rgba(0,0,0,.12);
}

/* Icons */
.card-icon {
    width: 56px;
    height: 56px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 22px;
    color: #fff;
    flex-shrink: 0;
}

/* Text */
.card-content h5 {
    margin-bottom: 6px;
    font-weight: 600;
    color: #111;
}

.card-content p {
    margin: 0;
    font-size: 14px;
    color: #555;
}

/* COLOR VARIANTS */
.bg-blue {
    background: linear-gradient(135deg, #e8f1ff, #f6f9ff);
}
.bg-blue-dark {
    background: #0d6efd;
}

.bg-orange {
    background: linear-gradient(135deg, #fff1e6, #fff7f1);
}
.bg-orange-dark {
    background: #fd7e14;
}

.bg-green {
    background: linear-gradient(135deg, #e9f9ee, #f4fdf7);
}
.bg-green-dark {
    background: #198754;
}

/* Responsive tweaks */
@media (max-width: 576px) {
    .dashboard-header h2 {
        font-size: 22px;
    }
}
/* ===== QUICK ACTIONS: FORCE SINGLE ROW ON DESKTOP ===== */
@media (min-width: 1200px) {

    .admin-dashboard .row.g-4 {
        flex-wrap: nowrap;   /* 🔥 keeps cards on one line */
    }

    .admin-dashboard .row.g-4 > div {
        flex: 0 0 33.3333%;
        max-width: 33.3333%;
    }
}


</style>
 


<div style="padding-left: 12px; margin-top:40px;"class="hp-main-layout-content">
    <div class="page-header-modern">
        <h2 class=""></h2>

    <div class="dropdown">
        <button
            class="btn btn-user dropdown-toggle"
            type="button"
            id="userDropdown"
            data-bs-toggle="dropdown"
            aria-expanded="false"
        >
            <i class=""></i>
            <span class="user-name capitalize">
                <img src="../images/icon/invoice360-user.png" height=30px; width=30px;>
            </span>
        </button>

        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
            <li>
                <a class="dropdown-item" href="">
                    <i class="fa fa-user me-2"></i>   <?php echo strtok($_SESSION['user_name'], ' ');?> (<?php echo $_SESSION['role']; ?>)
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="payment-details.php">
                    <i class="fa fa-credit-card"></i> Billing history
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="company-profile.php">
                    <i class="fa fa-cog me-2"></i> Settings
                </a>
            </li>

            <li><hr class="dropdown-divider"></li>

            <li>
                <a class="dropdown-item text-danger" href="logout.php">
                    <i class="fa fa-sign-out me-2"></i> Sign Out
                </a>
            </li>
        </ul>
    </div>
    </div>

              <div class="container-fluid py-4 admin-dashboard">

    <!-- HEADER -->
    <div class="row mb-4">
        <div class="col-12">
            <div style="margin-bottom: 30px;" class="dashboard-header d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center">
                <div>
                    <h2 class="fw-bold mb-1">Welcome back, Admin 👋</h2>
                    <p class="text-muted mb-0">
                        Manage your company settings, users, and permissions
                    </p>
                </div>

                
            </div>
        </div>
    </div>

    <!-- QUICK ACTIONS -->
    <div class="row g-4">

        <!-- Company Settings -->
        <div class="col-12 col-md-6 col-xl-4">
            <a href="company-information.php" class="dashboard-card bg-blue">
                <div class="card-body">
                    <div class="card-icon bg-blue-dark">
                        <i class="fa fa-building"></i>
                    </div>
                    <div class="card-content">
                        <h5>Company Settings</h5>
                        <p>Update company profile, branding & preferences</p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Manage Users -->
        <div class="col-12 col-md-6 col-xl-4">
            <a href="user-list.php" class="dashboard-card bg-orange">
                <div class="card-body">
                    <div class="card-icon bg-orange-dark">
                        <i class="fa fa-users"></i>
                    </div>
                    <div class="card-content">
                        <h5>Manage Users</h5>
                        <p>View, edit roles and manage access</p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Add User -->
        <div class="col-12 col-md-6 col-xl-4">
            <a href="payment-details.php" class="dashboard-card bg-green">
                <div class="card-body">
                    <div class="card-icon bg-green-dark">
                        <i class="fa fa-history"></i>
                    </div>
                    <div class="card-content">
                        <h5>Billing History</h5>
                        <p>View your past payments and download receipts</p>
                    </div>
                </div>
            </a>
        </div>

    </div>

</div>

            <?php include ('footer.php'); ?>     

    <!-- Plugin -->
    <script src="../app-assets/js/plugin/jquery.min.js"></script>
    <script src="../app-assets/js/plugin/bootstrap.bundle.min.js"></script>
    <script src="../app-assets/js/plugin/swiper-bundle.min.js"></script>
    <script src="../app-assets/js/plugin/jquery.mask.min.js"></script>
    <script src="../app-assets/js/plugin/autocomplete.min.js"></script>
    <script src="../app-assets/js/plugin/moment.min.js"></script>

    <!-- Layouts -->
    <script src="../app-assets/js/layouts/header-search.js"></script>
    <script src="../app-assets/js/layouts/sider.js"></script>
    <script src="../app-assets/js/components/input-number.js"></script>

    <!-- Base -->
    <script src="../app-assets/js/base/index.js"></script>
    <!-- Customizer -->
    <script src="../app-assets/js/customizer.js"></script>

    <!-- Charts -->
    <script src="../app-assets/js/plugin/apexcharts.min.js"></script>
    <script src="../app-assets/js/charts/apex-chart.js"></script>

    <!-- Cards -->
    <script src="../app-assets/js/cards/card-advance.js"></script>
    <script src="../app-assets/js/cards/card-analytic.js"></script>
    <script src="../app-assets/js/cards/card-statistic.js"></script>

    <!-- Pages -->
    <script src="../app-assets/js/pages/dashboard-ecommerce.js"></script>

    <!-- Custom -->
    <script src="../assets/js/main.js"></script>

</body>



</html>