<?php
session_start();
require_once('../includes/config.php');

/* =========================
   SECURITY CHECK
========================= */
if (!isset($_SESSION['company_id'])) {
       	echo "
        <script>
            alert('Company context missing. Please re-login.');
            window.location.href = '../sign-in.php';
        </script>
        ";
    exit;
}

$company_id = (int) $_SESSION['company_id'];

/* =========================
   DB CHECK
========================= */
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

/* =========================
   SAFE POST VARIABLES
========================= */
$company_name    = $_POST['company_name'] ?? '';
$company_address = $_POST['company_address'] ?? '';
$company_town    = $_POST['company_town'] ?? '';
$company_phone   = $_POST['company_phone'] ?? '';
$company_state   = $_POST['company_state'] ?? '';
$country         = $_POST['country'] ?? '';
$company_email   = $_POST['company_email'] ?? '';

$bank_name    = $_POST['bank_name'] ?? '';
$account_no   = $_POST['account_no'] ?? '';
$account_name = $_POST['account_name'] ?? '';

$currency      = $_POST['currency'] ?? '';
$enable_vat    = isset($_POST['enable_vat']) ? 1 : 0;
$vat_rate      = $_POST['vat_rate'] ?? 0;
$year_target   = $_POST['year_target'] ?? 0;

$initial_value_invoice     = $_POST['initial_value_invoice'] ?? 0;
$initial_value_voucher     = $_POST['initial_value_voucher'] ?? 0;
$initial_value_transaction = $_POST['initial_value_transaction'] ?? 0;

$theme          = $_POST['theme'] ?? '';
$terms          = $_POST['terms'] ?? '';
$invoice_prefix = $_POST['invoice_prefix'] ?? '';

/* =========================
   HANDLE LOGO UPLOAD
========================= */
$company_logo = null;
$logo_sql     = "";

if (!empty($_FILES['company_logo']['name'])) {

    $ext = pathinfo($_FILES['company_logo']['name'], PATHINFO_EXTENSION);
    $company_logo = 'logo_' . $company_id . '_' . time() . '.' . $ext;
    $path = '../images/' . $company_logo;

    if (!move_uploaded_file($_FILES['company_logo']['tmp_name'], $path)) {
        echo "<script>alert('Logo upload failed'); window.location='company-information.php';</script>";
        exit;
    }

    $logo_sql = ", company_logo = ?";
}

/* =========================
   PREPARED UPDATE QUERY
========================= */
$sql = "
UPDATE company SET
    company_name = ?,
    company_address = ?,
    company_town = ?,
    company_phone = ?,
    company_state = ?,
    country = ?,
    company_email = ?,
    bank_name = ?,
    account_no = ?,
    account_name = ?,
    currency = ?,
    enable_vat = ?,
    vat_rate = ?,
    initial_value_invoice = ?,
    initial_value_voucher = ?,
    initial_value_transaction = ?,
    theme = ?,
    terms = ?,
    year_target = ?,
    invoice_prefix = ?
    $logo_sql
WHERE id = ?
";

$stmt = $conn->prepare($sql);

/* =========================
   BIND PARAMETERS (MATCHED)
========================= */
if ($company_logo) {

    $stmt->bind_param(
        "sssssssssssiddiiissssi",
        $company_name,
        $company_address,
        $company_town,
        $company_phone,
        $company_state,
        $country,
        $company_email,
        $bank_name,
        $account_no,
        $account_name,
        $currency,
        $enable_vat,
        $vat_rate,
        $initial_value_invoice,
        $initial_value_voucher,
        $initial_value_transaction,
        $theme,
        $terms,
        $year_target,
        $invoice_prefix,
        $company_logo,
        $company_id
    );

} else {

    $stmt->bind_param(
        "sssssssssssiddiiisssi",
        $company_name,
        $company_address,
        $company_town,
        $company_phone,
        $company_state,
        $country,
        $company_email,
        $bank_name,
        $account_no,
        $account_name,
        $currency,
        $enable_vat,
        $vat_rate,
        $initial_value_invoice,
        $initial_value_voucher,
        $initial_value_transaction,
        $theme,
        $terms,
        $year_target,
        $invoice_prefix,
        $company_id
    );
}

/* =========================
   EXECUTE
========================= */
if ($stmt->execute()) {
    echo "<script>
        alert('Company settings updated successfully');
        window.location='company-information.php';
    </script>";
} else {
    echo "<script>
        alert('Update failed. Please try again.');
        window.location='company-information.php';
    </script>";
}

$stmt->close();
$conn->close();
?>
