<?php
include('nav.php');

 

?> 
                                                
<?php


/* =========================
   AUTH & CONTEXT
========================= */


$company_id = (int) $_SESSION['company_id'];

/* =========================
   FETCH COMPANY
========================= */
$stmt = $conn->prepare("
    SELECT company_name
    FROM company
    WHERE id = ?
    LIMIT 1
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$company = $stmt->get_result()->fetch_assoc();

/* =========================
   FETCH SUBSCRIPTION
========================= */
$stmt = $conn->prepare("
    SELECT
        plan,
        status,
        started_at,
        ends_at,
        amount
    FROM subscriptions
    WHERE company_id = ?
    ORDER BY id DESC
    LIMIT 1
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$subscription = $stmt->get_result()->fetch_assoc();

if (!$subscription) {
           	echo "
        <script>
            alert('No Subscription.');
            window.location.href = 'index.php';
        </script>
        ";
    exit;
}

/* =========================
   FORMAT VALUES
========================= */
$plan        = ucfirst($subscription['plan']);
$status      = ucfirst($subscription['status']);
$amount      = number_format($subscription['amount'], 2);
$started_at  = date("d M Y", strtotime($subscription['started_at']));
$ends_at     = date("d M Y", strtotime($subscription['ends_at']));

$statusClass = match ($subscription['status']) {
    'active' => 'badge-success',
    'trial'  => 'badge-warning',
    default  => 'badge-danger'
};
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Billing Overview</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.4.1/dist/css/bootstrap.min.css">

<style>
body {
    background: #f5f7fa;
    font-family: "Segoe UI", sans-serif;
}

.billing-card {
    max-width: 700px;
    margin: 60px auto;
    background: #ffffff;
    border-radius: 10px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.08);
    padding: 30px;
}

.billing-header {
    border-bottom: 1px solid #eee;
    margin-bottom: 25px;
    padding-bottom: 15px;
}

.billing-header h2 {
    margin: 0;
}

.info-row {
    display: flex;
    justify-content: space-between;
    padding: 12px 0;
    border-bottom: 1px dashed #eee;
}

.info-row:last-child {
    border-bottom: none;
}

.info-label {
    font-weight: 600;
    color: #555;
}

.info-value {
    font-weight: 500;
}

.actions {
    margin-top: 30px;
    text-align: right;
}
</style>
</head>

<body>

<div class="billing-card">

    <div class="billing-header">
        <h2><?= htmlspecialchars($company['company_name']) ?></h2>
        <p class="text-muted">Subscription & Billing Details</p>
    </div>

    <div class="info-row">
        <span class="info-label">Plan</span>
        <span class="info-value"><?= $plan ?></span>
    </div>

    <div class="info-row">
        <span class="info-label">Status</span>
        <span class="info-value">
            <span class="badge <?= $statusClass ?>">
                <?= $status ?>
            </span>
        </span>
    </div>

    <div class="info-row">
        <span class="info-label">Started On</span>
        <span class="info-value"><?= $started_at ?></span>
    </div>

    <div class="info-row">
        <span class="info-label">Expires On</span>
        <span class="info-value"><?= $ends_at ?></span>
    </div>

    <div class="info-row">
        <span class="info-label">Amount Paid</span>
        <span class="info-value">₦<?= $amount ?></span>
    </div>

    <div class="actions">
        <a href="view-receipt.php" class="btn btn-primary">
            <span class="glyphicon glyphicon-file"></span>
            View Receipt
        </a>
    </div>

</div>

</body>
</html>



                                                
            <?php include ('footer.php'); ?>     

    <!-- Plugin -->
    <script src="app-assets/js/plugin/jquery.min.js"></script>
    <script src="app-assets/js/plugin/bootstrap.bundle.min.js"></script>
    <script src="app-assets/js/plugin/swiper-bundle.min.js"></script>
    <script src="app-assets/js/plugin/jquery.mask.min.js"></script>
    <script src="app-assets/js/plugin/autocomplete.min.js"></script>
    <script src="app-assets/js/plugin/moment.min.js"></script>

    <!-- Layouts -->
    <script src="app-assets/js/layouts/header-search.js"></script>
    <script src="app-assets/js/layouts/sider.js"></script>
    <script src="app-assets/js/components/input-number.js"></script>

    <!-- Base -->
    <script src="app-assets/js/base/index.js"></script>
    <!-- Customizer -->
    <script src="app-assets/js/customizer.js"></script>

    <!-- Charts -->
    <script src="app-assets/js/plugin/apexcharts.min.js"></script>
    <script src="app-assets/js/charts/apex-chart.js"></script>

    <!-- Cards -->
    <script src="app-assets/js/cards/card-advance.js"></script>
    <script src="app-assets/js/cards/card-analytic.js"></script>
    <script src="app-assets/js/cards/card-statistic.js"></script>

    <!-- Pages -->
    <script src="app-assets/js/pages/dashboard-ecommerce.js"></script>

    <!-- Custom -->
    <script src="assets/js/main.js"></script>
    <script type="text/javascript">





// Analytics Revenue 1
let optionsAnalyticsRevenue1 = {
    series: [
        {
            name: "Total Bills",
            data: [
                1<?php echo $sumt1; ?>, <?php echo $sumt2; ?>, <?php echo $sumt3; ?>, <?php echo $sumt4; ?>, <?php echo $sumt5; ?>,<?php echo $sumt6; ?>, <?php echo $sumt7; ?>, <?php echo $sumt8; ?>, <?php echo $sumt9; ?>, <?php echo $sumt10; ?>,
                <?php echo $sumt11; ?>, <?php echo $sumt12; ?>
            ],
        },
        {
            name: "Paid Bills",
            data: [
                <?php echo $sump1; ?>, <?php echo $sump2; ?>, <?php echo $sump3; ?>, <?php echo $sump4; ?>, <?php echo $sump5; ?>,<?php echo $sump6; ?>, <?php echo $sump7; ?>, <?php echo $sump8; ?>, <?php echo $sump9; ?>, <?php echo $sump10; ?>,
                <?php echo $sump11; ?>, <?php echo $sump12; ?>
            ],
        },
        {
            name: "Pending Bills",
            data: [
                <?php echo $sumpe1; ?>, <?php echo $sumpe2; ?>, <?php echo $sumpe3; ?>, <?php echo $sumpe4; ?>, <?php echo $sumpe5; ?>,<?php echo $sumpe6; ?>, <?php echo $sumpe7; ?>, <?php echo $sumpe8; ?>, <?php echo $sumpe9; ?>, <?php echo $sumpe10; ?>,
                <?php echo $sumpe11; ?>, <?php echo $sumpe12; ?>
            ],
        },
    ],
    chart: {
        id: "analytics-revenue-chart",
        fontFamily: "Manrope, sans-serif",
        type: "bar",
        height: 300,
        toolbar: {
            show: false,
        },
        zoom: {
            enabled: false,
        },
    },
    labels: {
        style: {
            fontSize: "14px",
        },
    },

    dataLabels: {
        enabled: false,
    },

    grid: {
        borderColor: "#DFE6E9",
        row: {
            opacity: 0.5,
        },
    },
    plotOptions: {
        bar: {
            horizontal: false,
            borderRadius: 2,
            columnWidth: "65%",
            endingShape: "rounded",
        },
        colors: {
            backgroundBarColors: ["#0063F7", "#00F7BF"],
        },
    },

    stroke: {
        show: true,
        width: 4,
        colors: ["transparent"],
    },
    xaxis: {
        axisTicks: {
            show: false,
            borderType: "solid",
            color: "#78909C",
            height: 6,
            offsetX: 0,
            offsetY: 0,
        },

        tickPlacement: "between",
        labels: {
            style: {
                colors: ["636E72"],
                fontSize: "14px",
            },
        },
        categories: [
            "Jan",
            "Feb",
            "Mar",
            "Apr",
            "May",
            "Jun",
            "Jul",
            "Aug",
            "Sep",
            "Oct",
            "Nov",
            "Dec",
        ],
    },
    legend: {
        horizontalAlign: "right",
        offsetX: 40,
        position: "top",
        markers: {
            radius: 12,
        },
    },
    yaxis: {
        labels: {
            style: {
                colors: ["636E72"],
                fontSize: "14px",
            },
            formatter: (value) => {
                return value;
            },
        },

        min: 0,
        max: 2000000,
        tickAmount: 4,
    },
};

if (document.querySelector("#analytics-revenue-chart")) {
    let chart = new ApexCharts(document.querySelector("#analytics-revenue-chart"), optionsAnalyticsRevenue1);
    chart.render();
}
</script>
</body>



</html>