<?php
session_start();
$isLoggedIn = isset($_SESSION['company_id']);

?>


<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Billing | Finvoicer</title>
 <!-- Favicon -->
    <link rel="apple-touch-icon" sizes="180x180" href="app-assets/favicon/inv.png">
    <link rel="icon" type="image/png" sizes="32x32" href="app-assets/favicon/inv.png">
    <link rel="icon" type="image/png" sizes="16x16" href="app-assets/favicon/inv.png">
    <link rel="manifest" href="app-assets/favicon/inv.png">
    <link rel="mask-icon" href="app-assets/favicon/inv.png" color="#0010f7">
    <meta name="msapplication-TileColor" content="#0010f7">
    <meta name="theme-color" content="#ffffff">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">



<style>
    body {
        margin: 0;
        padding: 0;
        background: #f4f6f8;
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Arial, sans-serif;
        color: #1f2937;
    }

    .billing-container {
        max-width: 1100px;
        margin: 60px auto;
        padding: 0 2px;
    }

    .billing-header {
        text-align: center;
        margin-bottom: 50px;
    }

    .billing-header h1 {
        font-size: 34px;
        margin-bottom: 10px;
        font-weight: 700;
    }

    .billing-header p {
        font-size: 16px;
        color: #6b7280;
    }

    .plans {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
        gap: 30px;
    }

    .plan-card {
        background: #ffffff;
        border-radius: 14px;
        padding: 35px 30px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.06);
        position: relative;
        transition: transform .25s ease, box-shadow .25s ease;
    }

    .plan-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 18px 45px rgba(0,0,0,0.1);
    }

    .plan-badge {
        position: absolute;
        top: -12px;
        right: 20px;
        background: #16a34a;
        color: #fff;
        padding: 6px 14px;
        font-size: 12px;
        font-weight: 600;
        border-radius: 20px;
    }

    .plan-title {
        font-size: 22px;
        font-weight: 700;
        margin-bottom: 8px;
    }

    .plan-price {
        font-size: 36px;
        font-weight: 800;
        margin: 20px 0 5px;
    }

    .plan-duration {
        color: #6b7280;
        font-size: 14px;
        margin-bottom: 25px;
    }

    .plan-features {
        list-style: none;
        padding: 0;
        margin: 0 0 30px;
    }

    .plan-features li {
        padding: 8px 0;
        font-size: 15px;
        color: #374151;
    }

    .plan-features li::before {
        content: "✔";
        color: #16a34a;
        font-weight: bold;
        margin-right: 10px;
    }

    .plan-action button {
        width: 100%;
        padding: 14px;
        font-size: 16px;
        font-weight: 600;
        border-radius: 10px;
        border: none;
        cursor: pointer;
        transition: background .2s ease;
    }

    .btn-monthly {
        background: #2563eb;
        color: #fff;
    }

    .btn-monthly:hover {
        background: #1d4ed8;
    }

    .btn-annual {
        background: #16a34a;
        color: #fff;
    }

    .btn-annual:hover {
        background: #15803d;
    }

    .billing-footer {
        text-align: center;
        margin-top: 50px;
        font-size: 13px;
        color: #6b7280;
    }

    /* =========================
   TOP NAVIGATION
========================= */
.top-nav {
    position: sticky;
    top: 0;
    z-index: 1000;
    background: #ffffff;
    border-bottom: 1px solid #e5e7eb;
    padding: 14px 28px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.nav-left,
.nav-right {
    display: flex;
    align-items: center;
}

.nav-btn {
    text-decoration: none;
    font-size: 14px;
    font-weight: 600;
    padding: 10px 18px;
    border-radius: 8px;
    color: #374151;
    background: #f3f4f6;
    transition: all 0.2s ease;
}

.nav-btn:hover {
    background: #e5e7eb;
}

.nav-btn.primary {
    background: #2563eb;
    color: #ffffff;
}

.nav-btn.primary:hover {
    background: #1d4ed8;
}

/* =========================
   MOBILE OPTIMIZATION
========================= */

/* General spacing */
@media (max-width: 768px) {

    body {
        font-size: 15px;
    }

    .billing-container {
        margin: 30px auto;
        padding: 0 16px;
    }

    .billing-header h1 {
        font-size: 26px;
    }

    .billing-header p {
        font-size: 14px;
    }

    /* Stack nav properly */
    .top-nav {
        padding: 12px 16px;
        flex-wrap: wrap;
        gap: 10px;
    }

    .nav-left,
    .nav-right {
        width: 100%;
        justify-content: center;
    }

    .nav-btn {
        width: 100%;
        text-align: center;
        padding: 12px;
        font-size: 15px;
    }

    /* Plans grid */
    .plans {
        grid-template-columns: 1fr;
        gap: 20px;
    }

    .plan-card {
        padding: 26px 22px;
    }

    .plan-title {
        font-size: 20px;
    }

    .plan-price {
        font-size: 30px;
    }

    .plan-features li {
        font-size: 14px;
    }

    .plan-action button {
        font-size: 15px;
        padding: 14px;
    }

    .billing-footer {
        font-size: 12px;
        padding: 0 10px;
    }
}

/* Extra small devices */
@media (max-width: 480px) {

    .billing-header h1 {
        font-size: 22px;
    }

    .plan-price {
        font-size: 26px;
    }

    .plan-badge {
        font-size: 11px;
        padding: 5px 12px;
    }
}

</style>

</head>

<body>
  <!-- TOP NAV BAR -->
<div class="top-nav">
    <div class="nav-left">
      <?php if ($isLoggedIn): ?>
        <a href="dashboard.php" class="nav-btn">🏠 Dashboard</a>
        <?php else: ?>
         <a href="index.php" class="nav-btn">🏠 Home</a> 
         <?php endif; ?>
    </div>

    <div class="nav-right">
        <?php if ($isLoggedIn): ?>
            <a href="contact.php" class="nav-btn primary">Contact Support</a>
        <?php else: ?>
            <a href="contact.php" class="nav-btn primary">Contact Support</a>
        <?php endif; ?>
    </div>
</div>



<div class="billing-container">

    <div class="billing-header">
        <h1>Choose Your Plan</h1>
        <p>Start with a free trial. Upgrade anytime to keep enjoying Finvoicer.</p>
        <p>Finvoicer is an all-in-one business management solution designed to prepare, record, and track invoices, vouchers, expenses, and transactions—while also providing a built-in schedule tracker and support for multiple users. Our pricing reflects the value of a reliable system that helps businesses stay organized, efficient, and in control, with continuous improvements and dedicated support.</p>
    </div>

    <div class="plans">

        <!-- Monthly Plan -->
        <div class="plan-card">
            <div class="plan-title">Monthly Plan</div>
            <div class="plan-price">₦5,000</div>
            <div class="plan-duration">per month</div>

            <ul class="plan-features">
                <li>Unlimited invoices & vouchers</li>
                <li>Expense & transaction tracking</li>
                <li>Email invoice sharing</li>
                <li>PDF downloads</li>
                <li>Priority support</li>
            </ul>

            <form method="POST" action="endpoint/pay.php" class="plan-action">
                <input type="hidden" name="plan" value="monthly">
                <button type="submit" class="btn-monthly">
                    Pay ₦5,000 Monthly
                </button>
            </form>
        </div>

        <!-- Annual Plan -->
        <div class="plan-card">
            <div class="plan-badge">Best Value</div>

            <div class="plan-title">Annual Plan</div>
            <div class="plan-price">₦50,000</div>
            <div class="plan-duration">per year (2 months free)</div>

            <ul class="plan-features">
                <li>Everything in Monthly</li>
                <li>Save ₦10,000 yearly</li>
                <li>Advanced reports</li>
                <li>Dedicated support</li>
                <li>Early access to new features</li>
            </ul>

            <form method="POST" action="endpoint/pay.php" class="plan-action">
                <input type="hidden" name="plan" value="annual">
                <button type="submit" class="btn-annual">
                    Pay ₦50,000 Annually
                </button>
            </form>
        </div>

    </div>

    

    <div class="billing-footer">
        Secure payments powered by Paystack · Cancel anytime · No hidden fees
    </div>

</div>
</div>







                                    
                                   

		








             
		
 <!-- Plugin -->
 	
 	
    <script src="app-assets/js/plugin/swiper-bundle.min.js"></script>
    <script src="app-assets/js/plugin/jquery.mask.min.js"></script>
    <script src="app-assets/js/plugin/autocomplete.min.js"></script>
    <script src="app-assets/js/plugin/moment.min.js"></script>

    <!-- Layouts -->
    <script src="app-assets/js/layouts/header-search.js"></script>
    <script src="app-assets/js/layouts/sider.js"></script>
    <script src="app-assets/js/components/input-number.js"></script>

    <!-- Base -->
    <script src="app-assets/js/base/index.js"></script>
    <!-- Customizer -->
    <script src="app-assets/js/customizer.js"></script>

    <!-- Charts -->
    <script src="app-assets/js/plugin/apexcharts.min.js"></script>
    <script src="app-assets/js/charts/apex-chart.js"></script>

    <!-- Cards -->
    <script src="app-assets/js/cards/card-advance.js"></script>
    <script src="app-assets/js/cards/card-analytic.js"></script>
    <script src="app-assets/js/cards/card-statistic.js"></script>

    <!-- Pages -->
    <script src="app-assets/js/pages/dashboard-ecommerce.js"></script>

    <!-- Custom -->
    <script src="assets/js/main.js"></script>  
	

</body>


</html>