<?php
declare(strict_types=1);

include('nav-home2.php');
require_once 'includes/config.php';

/* =========================
   AUTH
========================= */
if (!isset($_SESSION['company_id'])) {
    header('Location: sign-in.php');
    exit;
}

$company_id = (int) $_SESSION['company_id'];

/* =========================
   DB CONNECTION
========================= */
$mysqli = new mysqli(
    DATABASE_HOST,
    DATABASE_USER,
    DATABASE_PASS,
    DATABASE_NAME
);
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

/* =========================
   COMPANY INFO
========================= */
$stmt = $mysqli->prepare("
    SELECT company_name, currency
    FROM company
    WHERE id = ?
    LIMIT 1
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$company = $stmt->get_result()->fetch_assoc();

$companyName = $company['company_name'];
$currency    = $company['currency'];

/* =========================
   MONTHLY INVOICE STATS (ONE QUERY)
========================= */
$monthly = array_fill(1, 12, [
    'total'   => 0,
    'paid'    => 0,
    'pending' => 0
]);

$stmt = $mysqli->prepare("
    SELECT 
        MONTH(invoice_date) AS m,
        SUM(total) AS total,
        SUM(CASE WHEN status='Paid' THEN total ELSE 0 END) AS paid,
        SUM(CASE WHEN status='Pending' THEN total ELSE 0 END) AS pending
    FROM invoices
    WHERE company_id = ?
      AND YEAR(invoice_date) = YEAR(CURDATE())
    GROUP BY MONTH(invoice_date)
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$res = $stmt->get_result();

while ($row = $res->fetch_assoc()) {
    $m = (int) $row['m'];
    $monthly[$m] = [
        'total'   => (float) $row['total'],
        'paid'    => (float) $row['paid'],
        'pending' => (float) $row['pending']
    ];
}

/* =========================
   CURRENT MONTH COUNTS
========================= */
$stmt = $mysqli->prepare("
    SELECT
        COUNT(*) AS total_count,
        COUNT(CASE WHEN status='Paid' THEN 1 END) AS paid_count,
        COUNT(CASE WHEN status='Pending' THEN 1 END) AS pending_count
    FROM invoices
    WHERE company_id = ?
      AND YEAR(invoice_date) = YEAR(CURDATE())
      AND MONTH(invoice_date) = MONTH(CURDATE())
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$monthCounts = $stmt->get_result()->fetch_assoc();


/* =========================
   CHART DATA (SAFE FOR JS)
========================= */
$chartTotal   = [];
$chartPaid    = [];
$chartPending = [];

for ($m = 1; $m <= 12; $m++) {
    $chartTotal[]   = $monthly[$m]['total'];
    $chartPaid[]    = $monthly[$m]['paid'];
    $chartPending[] = $monthly[$m]['pending'];
}


/* ========================= 
   YEAR SUMMARY
========================= */
$stmt = $mysqli->prepare("
    SELECT
        COUNT(*) AS total_count,

        COUNT(CASE WHEN status = 'Paid' THEN 1 END) AS paid_count,
        COUNT(CASE WHEN status = 'Pending' THEN 1 END) AS pending_count,

        COALESCE(SUM(total), 0) AS total_amount,
        COALESCE(SUM(CASE WHEN status = 'Paid' THEN total END), 0) AS paid_amount,
        COALESCE(SUM(CASE WHEN status = 'Pending' THEN total END), 0) AS pending_amount

    FROM invoices
    WHERE company_id = ?
      AND YEAR(invoice_date) = YEAR(CURDATE())
");

$stmt->bind_param("i", $company_id);
$stmt->execute();
$summary = $stmt->get_result()->fetch_assoc();

/* =========================
   LATEST INVOICES
========================= */
$stmt = $mysqli->prepare("
    SELECT i.invoice, i.invoice_date, i.invoice_type, i.total, i.status, c.name
    FROM invoices i
    JOIN customers c 
        ON c.invoice = i.invoice 
       AND c.company_id = i.company_id
    WHERE i.company_id = ?
    ORDER BY i.invoice_date DESC
    LIMIT 5
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$latestInvoices = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);


$currentMonth = (int) date('n');

$totalAmount   = $monthly[$currentMonth]['total'];
$paidAmount    = $monthly[$currentMonth]['paid'];
$pendingAmount = $monthly[$currentMonth]['pending'];

$totalCount    = (int) ($monthCounts['total_count'] ?? 0);
$paidCount     = (int) ($monthCounts['paid_count'] ?? 0);
$pendingCount  = (int) ($monthCounts['pending_count'] ?? 0);
?>


                                               
<div style=" margin-left: 3px;" class="hp-main-layout-content">
                <div class="row mb-32 gy-32">
                    <div class="col-12">
<div class="page-header-modern d-flex align-items-center justify-content-between">
    
    <!-- LEFT: Page title -->
    <h2 class="">

    </h2>

    <!-- RIGHT: User dropdown -->
    <div class="dropdown">
        <button
            class="btn btn-user dropdown-toggle"
            type="button"
            id="userDropdown"
            data-bs-toggle="dropdown"
            aria-expanded="false"
        >
            <i class="fa fa-user-circle me-1"></i>
            <span class="user-name capitalize">
                <?php echo $_SESSION['role']; ?>
            </span>
        </button>

        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
            <li>
                <a class="dropdown-item" href="">
                    <i class="fa fa-user me-2"></i>   <?php echo strtok($_SESSION['user_name'], ' ');?>
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="Admin/payment-details.php">
                    <i class="fa fa-credit-card"></i> Billing history
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="Admin/company-profile.php">
                    <i class="fa fa-cog me-2"></i> Settings
                </a>
            </li>

            <li><hr class="dropdown-divider"></li>

            <li>
                <a class="dropdown-item text-danger" href="logout.php">
                    <i class="fa fa-sign-out me-2"></i> Sign Out
                </a>
            </li>
        </ul>
    </div>

</div>
    
<div class="row mb-32">
    <div class="col-12">
        <div class="dashboard-header">
            <div class="header-icon">
                <i class="ti-calendar"></i>
            </div>
            <div class="header-text">
                <h3>Activities Analysis</h3>
                <p><?= htmlspecialchars($companyName) ?></p>
            </div>
        </div>
    </div>
</div>
                    </div>

                    <div class="col-12">
                    <div class="row g-32 mb-32">
                    <div class="col-12 col-md-6 col-xl-3">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row g-16">
                                            <div class="col-6 hp-flex-none w-auto">
                                                <div class="">
                                                    <i class="iconly-Light-Buy text-secondary" style="font-size: 15px;"></i>
                                                </div>
                                            </div>

                                            <div class="col">                                            
                                                <h4><?= $currency ?> <?= number_format((float) ($summary['total_amount'] ?? 0), 2) ?></h4>
                                                <span style="font-size: 13px;" class="text-secondary">(
                                                    <?= (int)$summary['total_count'] ?> Invoices)</span>
                                                <p style="font-size: 20px; font-weight: 600;" class="hp-p1-body mb-0 text-black-100 hp-text-color-dark-30">Bills Created</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>                  
                            

                                                       
                            <div class="col-12 col-md-6 col-xl-3">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row g-16">
                                            <div class="col-6 hp-flex-none w-auto">
                                                <div class="">
                                                    <i class="iconly-Light-Ticket text-danger" style="font-size: 19px;"></i>
                                                </div>
                                            </div>

                                            

                                            <div class="col">
                                                <h4>
                                          
                                                <?= $currency ?> <?= number_format((float) ($summary['pending_amount'] ?? 0), 2) ?></h4>
                                                 <span style="font-size: 13px;" class="text-danger">(
                                                    <?= (int)$summary['pending_count'] ?> Invoices)</span>
                                                <p style="font-size: 20px; font-weight: 600;" class="hp-p1-body mb-0 text-black-100 hp-text-color-dark-30">Pending Bills</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-md-6 col-xl-3">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row g-16">
                                            <div class="col-6 hp-flex-none w-auto">
                                                <div class="">
                                                    <i class="iconly-Light-Discount text-success" style="font-size: 19px;"></i>
                                                </div>
                                            </div>

                                            <div class="col">
                                            <h4><?= $currency ?> <?= number_format((float) ($summary['paid_amount'] ?? 0), 2) ?></h4>
                                                <span style="font-size: 13px;" class="text-secondary">(
                                                    <?= (int)$summary['paid_count'] ?> Invoices)</span>    
                                                <p style="font-size: 20px; font-weight: 600;" class="hp-p1-body mb-0 text-black-100 hp-text-color-dark-30">Paid Bills</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div> 
                            <div class="col-12 col-md-6 col-xl-3">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row g-16">
                                            <div class="col-6 hp-flex-none w-auto">
                                                <div class="">
                                                    <i class="iconly-Light-People text-primary hp-text-color-dark-primary-2" style="font-size: 19px;"></i>
                                                </div>
                                            </div>

                                            <div class="col">
                                                <h3 class="mb-4 mt-8">
                                                <?php 
                
                                                    $sql = "SELECT * FROM store_customers";
                                                    $query = $mysqli->query($sql);

                                                    echo "$query->num_rows";
                                                    ?>
                                                    </h3>
                                                <span class="text-primary hp-text-color-dark-primary-2">New</span>   
                                                <p style="font-size: 20px; font-weight: 600;"  class="hp-p1-body mb-0 text-black-100 hp-text-color-dark-30">Customers</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>                           
                        </div>
                        

                        <div class="row g-32">
                            <div class="col-12">
                                <div class="row g-32">
                                    <div class="col-12 col-xl-6">
                                        <div class="card hp-card-6 hp-chart-text-color">
                                            <div class="card-body">
                                                <div class="row justify-content-between mb-16">
                                                    <div class="col-6">
                                                        <h4 class="me-8">Invoicing Chart <?php echo date('Y');?></h4>
                                                    </div>
                                                </div>

                                                <div
                                                 id="analytics-revenue-chart">
                                                
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-12 col-xl-6">
                                        <div class="card hp-card-6 hp-chart-text-color">
                                            <div class="card-body">
                                                <div class="row justify-content-between mb-16">
                                                    <div class="col-6">
                                                        <h4 class="me-8">Transactons Chart <?php echo date('Y');?> </h4>
                                                    </div>
                                                </div>

                                                <div
                                                 id="analytics-revenue-chart">
                                                
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        </div>
                        </div>


                        <div class="row g-32">
                            <div class="col-12">
                                <div class="row g-32">
                                    <div class="col-12 col-xl-4">
                                        <div class="card hp-card-6 hp-chart-text-color">
                                            <div class="card-body">
                                                
                                                <div class="d-flex align-items-center justify-content-between mb-32">
            <h5 class="mb-0">Latest Invoices</h5>
            <a href="invoice-list.php" class="hp-p1-body mb-0 fw-medium text-black-100 hp-text-color-dark-0">View all orders</a>
            </div>
                        <div style="margin-top: -10px;" class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                    <tr>
                                        <th style="width: 10%;">
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Date</span>
                                        </th>
                                        <th style="width: 14%;">
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Inv. no</span>
                                        </th>
                                        <th style="width: ">
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase"> Name</span>
                                        </th>
                                        <th>
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Type</span>
                                        </th>
                                        <th>
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Amount</span>
                                        </th>
                                        
                                        <th class="text-center">
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Status</span>
                                        </th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php foreach ($latestInvoices as $row): ?>

                                
                                    <tr>
                                    <td class="ps-0">
                                        <span class="mb-0 fw-medium text-black-100 hp-text-color-dark-0"><?= date('d M Y', strtotime($row['invoice_date'])) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['invoice']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['name']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['invoice_type']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= number_format((float) ($row['total'] ?? 0), 2) ?> </span>
                                    </td>
                                    
                                    <td class="text-center">                            <span class="badge 
                                                    <?= $row['status']==='Paid' ? 'bg-success' :
                                                    ($row['status']==='Pending' ? 'bg-danger' : 'bg-warning') ?>">
                                                    <?= $row['status'] ?>
                                                </span>
                                    
                                </td>
                                    
                                
                            

                                </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                    </div>  
            
                                                
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-12 col-xl-4">
                                        <div class="card hp-card-6 hp-chart-text-color">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center justify-content-between mb-32">
            <h5 class="mb-0">Latest Transactions</h5>
            <a href="invoice-list.php" class="hp-p1-body mb-0 fw-medium text-black-100 hp-text-color-dark-0">View all orders</a>
            </div>
                        <div style="margin-top: -10px;" class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                    <tr>
                                        <th style="width: 10%;">
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Date</span>
                                        </th>
                                        <th style="width: 14%;">
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Inv. no</span>
                                        </th>
                                        <th style="width: ">
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase"> Name</span>
                                        </th>
                                        <th>
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Type</span>
                                        </th>
                                        <th>
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Amount</span>
                                        </th>
                                        
                                        <th class="text-center">
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Status</span>
                                        </th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php foreach ($latestInvoices as $row): ?>

                                
                                    <tr>
                                    <td class="ps-0">
                                        <span class="mb-0 fw-medium text-black-100 hp-text-color-dark-0"><?= date('d M Y', strtotime($row['invoice_date'])) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['invoice']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['name']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['invoice_type']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= number_format((float) ($row['total'] ?? 0), 2) ?> </span>
                                    </td>
                                    
                                    <td class="text-center">                            <span class="badge 
                                                    <?= $row['status']==='Paid' ? 'bg-success' :
                                                    ($row['status']==='Pending' ? 'bg-danger' : 'bg-warning') ?>">
                                                    <?= $row['status'] ?>
                                                </span>
                                    
                                </td>
                                    
                                
                            

                                </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                    </div>  
            
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-12 col-xl-4">
                                        <div class="card hp-card-6 hp-chart-text-color">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center justify-content-between mb-32">
            <h5 class="mb-0">Latest Vouchers</h5>
            <a href="invoice-list.php" class="hp-p1-body mb-0 fw-medium text-black-100 hp-text-color-dark-0">View all orders</a>
            </div>
                        <div style="margin-top: -10px;" class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                    <tr>
                                        <th style="width: 10%;">
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Date</span>
                                        </th>
                                        <th style="width: 14%;">
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Inv. no</span>
                                        </th>
                                        <th style="width: ">
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase"> Name</span>
                                        </th>
                                        <th>
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Type</span>
                                        </th>
                                        <th>
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Amount</span>
                                        </th>
                                        
                                        <th class="text-center">
                                            <span class="hp-badge-size d-block pb-16 fw-normal text-black-60 hp-text-color-dark-50 text-uppercase">Status</span>
                                        </th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php foreach ($latestInvoices as $row): ?>

                                
                                    <tr>
                                    <td class="ps-0">
                                        <span class="mb-0 fw-medium text-black-100 hp-text-color-dark-0"><?= date('d M Y', strtotime($row['invoice_date'])) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['invoice']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['name']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['invoice_type']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= number_format((float) ($row['total'] ?? 0), 2) ?> </span>
                                    </td>
                                    
                                    <td class="text-center">                            <span class="badge 
                                                    <?= $row['status']==='Paid' ? 'bg-success' :
                                                    ($row['status']==='Pending' ? 'bg-danger' : 'bg-warning') ?>">
                                                    <?= $row['status'] ?>
                                                </span>
                                    
                                </td>
                                    
                                
                            

                                </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                    </div>  
            
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        
                            







</div>

   




                                                        
                                                                    

                                                                    
                                                                    
                                                             
                                                      
                                        
                                                
                                            

                            
             
                            

                    


                
            

            <?php include ('footer.php'); ?>     

    <!-- Plugin -->
    <script src="app-assets/js/plugin/jquery.min.js"></script>
    <script src="app-assets/js/plugin/bootstrap.bundle.min.js"></script>
    <script src="app-assets/js/plugin/swiper-bundle.min.js"></script>
    <script src="app-assets/js/plugin/jquery.mask.min.js"></script>
    <script src="app-assets/js/plugin/autocomplete.min.js"></script>
    <script src="app-assets/js/plugin/moment.min.js"></script>

    <!-- Layouts -->
    <script src="app-assets/js/layouts/header-search.js"></script>
    <script src="app-assets/js/layouts/sider.js"></script>
    <script src="app-assets/js/components/input-number.js"></script>

    <!-- Base -->
    <script src="app-assets/js/base/index.js"></script>
    <!-- Customizer -->
    <script src="app-assets/js/customizer.js"></script>

    <!-- Charts -->
    <script src="app-assets/js/plugin/apexcharts.min.js"></script>
    <script src="app-assets/js/charts/apex-chart.js"></script>

    <!-- Cards -->
    <script src="app-assets/js/cards/card-advance.js"></script>
    <script src="app-assets/js/cards/card-analytic.js"></script>
    <script src="app-assets/js/cards/card-statistic.js"></script>

    <!-- Pages -->
    <script src="app-assets/js/pages/dashboard-ecommerce.js"></script>

    <!-- Custom -->
    <script src="assets/js/main.js"></script>


                <script>
            const chartTotal   = <?= json_encode($chartTotal, JSON_NUMERIC_CHECK) ?>;
            const chartPaid    = <?= json_encode($chartPaid, JSON_NUMERIC_CHECK) ?>;
            const chartPending = <?= json_encode($chartPending, JSON_NUMERIC_CHECK) ?>;
            </script>

    <script type="text/javascript">
// Analytics Revenue 1
const optionsAnalyticsRevenue1 = {
    series: [
        {
            name: "Total Bills",
            data: chartTotal
        },
        {
            name: "Paid Bills",
            data: chartPaid
        },
        {
            name: "Pending Bills",
            data: chartPending
        }
    ],

    chart: {
        type: "bar",
        height: 320,
        fontFamily: "Manrope, sans-serif",
        toolbar: { show: false }
    },

    dataLabels: { enabled: false },

    plotOptions: {
        bar: {
            horizontal: false,
            columnWidth: "60%",
            borderRadius: 4
        }
    },

    colors: ["#2563eb", "#16a34a", "#dc2626"],

    stroke: {
        show: true,
        width: 3,
        colors: ["transparent"]
    },

    xaxis: {
        categories: [
            "Jan","Feb","Mar","Apr","May","Jun",
            "Jul","Aug","Sep","Oct","Nov","Dec"
        ],
        labels: {
            style: { fontSize: "13px" }
        }
    },

    yaxis: {
        labels: {
            formatter: (val) => "₦" + val.toLocaleString()
        }
    },

    legend: {
        position: "top",
        horizontalAlign: "right"
    },

    grid: {
        borderColor: "#e5e7eb"
    }
};

if (document.querySelector("#analytics-revenue-chart")) {
    const chart = new ApexCharts(
        document.querySelector("#analytics-revenue-chart"),
        optionsAnalyticsRevenue1
    );
    chart.render();
}


</script>


</body>



</html>