<?php
function jsAlert($title, $message, $icon = 'info', $redirect = null) {

    $title   = htmlspecialchars($title, ENT_QUOTES);
    $message = htmlspecialchars($message, ENT_QUOTES);
    $icon    = htmlspecialchars($icon, ENT_QUOTES);
    $redirect = $redirect ? htmlspecialchars($redirect, ENT_QUOTES) : null;

    echo "
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset='UTF-8'>
        <title>Notification</title>
        <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
    </head>
    <body>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                Swal.fire({
                    target: document.body,
                    title: '{$title}',
                    text: '{$message}',
                    icon: '{$icon}',
                    confirmButtonColor: '#2c5364'
                }).then(() => {
                    " . ($redirect
                        ? "window.location.href = '{$redirect}';"
                        : "history.back();"
                    ) . "
                });
            });
        </script>
    </body>
    </html>";
    exit;
}
