<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Login Verification</title>
<link rel="apple-touch-icon" sizes="180x180" href="../app-assets/favicon/inv.png">
    <link rel="icon" type="image/png" sizes="32x32" href="../app-assets/favicon/inv.png">
    <link rel="icon" type="image/png" sizes="16x16" href="../app-assets/favicon/inv.png">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


<style>
/* ============================
   LOGIN OTP VERIFICATION PAGE
============================= */

* {
    box-sizing: border-box;
}

body {
    margin: 0;
    min-height: 100vh;
    background: linear-gradient(135deg, #f5f7fb, #eef2ff);
    font-family: 'Inter', 'Segoe UI', system-ui, -apple-system, sans-serif;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #111827;
}

/* ============================
   CARD CONTAINER
============================= */

.verify-card {
    width: 100%;
    max-width: 420px;
    background: #ffffff;
    border-radius: 18px;
    padding: 36px 32px;
    box-shadow: 0 25px 60px rgba(0, 0, 0, 0.1);
    text-align: center;
    animation: fadeInUp .4s ease;
}

/* ============================
   HEADINGS & TEXT
============================= */

.verify-card h2 {
    margin: 0 0 10px;
    font-size: 26px;
    font-weight: 700;
    color: #0f172a;
}

.verify-card .subtitle {
    font-size: 14px;
    line-height: 1.6;
    color: #475569;
    margin-bottom: 26px;
}

/* ============================
   OTP INPUT
============================= */

.otp-input-wrapper {
    margin-bottom: 22px;
}

.otp-input-wrapper input {
    width: 100%;
    height: 58px;
    font-size: 24px;
    font-weight: 600;
    text-align: center;
    letter-spacing: 10px;
    padding-left: 10px;
    border-radius: 14px;
    border: 1.5px solid #d1d5db;
    background: #f9fafb;
    color: #111827;
    outline: none;
    transition: all .25s ease;
}

.otp-input-wrapper input::placeholder {
    letter-spacing: 8px;
    color: #cbd5f5;
}

.otp-input-wrapper input:focus {
    border-color: #4f46e5;
    background: #ffffff;
    box-shadow: 0 0 0 4px rgba(79, 70, 229, 0.15);
}

/* ============================
   PAGE FOOTER
============================= */

.page-footer {
    position: fixed;
    bottom: 18px;
    width: 100%;
    text-align: center;
    font-size: 13px;
    color: #64748b;
    letter-spacing: 0.3px;
}

.page-footer strong {
    color: #1d1d1eff;
    font-weight: 600;
}


/* ============================
   BUTTONS
============================= */

.btn {
    width: 100%;
    height: 48px;
    border-radius: 12px;
    border: none;
    font-size: 15px;
    font-weight: 600;
    cursor: pointer;
    transition: all .25s ease;
}

/* Primary Button */
.btn-primary {
    background: linear-gradient(135deg, #4f46e5, #6366f1);
    color: #ffffff;
    box-shadow: 0 10px 25px rgba(79, 70, 229, 0.35);
}

.btn-primary:hover {
    transform: translateY(-1px);
    box-shadow: 0 14px 30px rgba(79, 70, 229, 0.45);
}

.btn-primary:active {
    transform: translateY(0);
}

/* Link Button (Resend) */
.btn-link {
    background: transparent;
    color: #4f46e5;
    font-size: 14px;
    margin-top: 14px;
}

.btn-link:hover {
    text-decoration: underline;
    color: #4338ca;
}

/* Disabled State */
.btn:disabled {
    background: #c7d2fe;
    cursor: not-allowed;
    box-shadow: none;
}

/* ============================
   FOOTER TEXT
============================= */

.verify-card .footer-text {
    margin-top: 22px;
    font-size: 13px;
    color: #64748b;
}

/* ============================
   ANIMATION
============================= */

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(16px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* ============================
   RESPONSIVE
============================= */

@media (max-width: 480px) {

    .verify-card {
        padding: 28px 22px;
    }

    .verify-card h2 {
        font-size: 22px;
    }

    .otp-input-wrapper input {
        font-size: 22px;
        letter-spacing: 8px;
    }
}


</style>
</head>

<body>

<div class="verify-card">

    <h2>Verify New Device</h2>

    <p class="subtitle">
        We detected a login from a new device.
        Please enter the 6-digit verification code sent to your email.
    </p>

    <!-- OTP FORM -->
    <form action="verify-login-otp.php" method="POST" autocomplete="off">

        <div class="otp-input-wrapper">
            <input
                type="text"
                name="otp"
                inputmode="numeric"
                pattern="[0-9]{6}"
                maxlength="6"
                placeholder="••••••"
                required
            >
        </div>

        <button type="submit" class="btn btn-primary w-100">
            Verify & Continue
        </button>
    </form>

    <!-- RESEND OTP -->
    <form action="resend-login-otp.php" method="POST" class="mt-3">
        <button type="submit" class="btn btn-link w-100">
            Resend verification code
        </button>
    </form>

    <div class="footer-text">
        Didn’t receive the code? Check your spam folder or wait a moment before resending.
    </div>

</div>


<footer class="page-footer">
    Powered by <strong>invoice360.</strong>
</footer>
</body>
</html>
