<?php


include('nav-mobile.php');

$getID = $_GET['id'];

// Connect to the database
$mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);

// output any connection error
if ($mysqli->connect_error) {
	die('Error : ('.$mysqli->connect_errno .') '. $mysqli->connect_error);
}

// the query
$query = "SELECT p.*, i.*, c.*
    FROM invoice_items p 
    JOIN invoices i ON i.invoice = p.invoice
    JOIN customers c ON c.invoice = i.invoice
    WHERE p.invoice = '" . $mysqli->real_escape_string($getID) . "'
    ORDER BY p.item_order ASC";

$result = mysqli_query($mysqli, $query);

// mysqli select query
if($result) {
	while ($row = mysqli_fetch_assoc($result)) {
		$customer_name = $row['name']; // customer name
		$customer_email = $row['email']; // customer email
		$customer_address_1 = $row['address_1']; // customer address
		$customer_address_2 = $row['address_2']; // customer address
		$customer_town = $row['town']; // customer town
		$customer_county = $row['county']; // customer county
		$customer_postcode = $row['postcode']; // customer postcode
		$customer_phone = $row['phone']; // customer phone number
		
		//shipping
		$customer_name_ship = $row['name_ship']; // customer name (shipping)
		$customer_address_1_ship = $row['address_1_ship']; // customer address (shipping)
		$customer_address_2_ship = $row['address_2_ship']; // customer address (shipping)
		$customer_town_ship = $row['town_ship']; // customer town (shipping)
		$customer_county_ship = $row['county_ship']; // customer county (shipping)
		$customer_postcode_ship = $row['postcode_ship']; // customer postcode (shipping)

		// invoice details
		$invoice_number = $row['invoice']; // invoice number
		$custom_email = $row['custom_email']; // invoice custom email body
		$invoice_date = $row['invoice_date']; // invoice date
		$invoice_due_date = $row['invoice_due_date']; // invoice due date
		$invoice_subtotal = $row['subtotal']; // invoice sub-total
		$invoice_shipping = $row['shipping']; // invoice shipping amount
		$invoicediscount = $row['discount']; // invoice discount
		$invoice_vat = $row['vat']; // invoice vat
		$invoice_total = $row['total']; // invoice total
		$invoice_notes = $row['notes']; // Invoice notes
		$invoice_type = $row['invoice_type']; // Invoice type
		$invoice_status = $row['status']; // Invoice status
	}
}



?>

<div style="margin-top: 20px;" class="hp-main-layout-content">
<div class="row mb-32 gy-32">
	    <div class="col-12">
    <div style="padding-left: 10px;"  class="page-header-modern">
            <h2 class="header-modern">Edit Voucher</h2>

    <div class="user-dropdown dropdown">
        <button class="btn btn-user" type="button" data-toggle="dropdown">
            <i class=""></i>
             <img src="images/icon/invoice360-user.png" height=30px; width=30px;>
            <span class="caret"></span>
        </button>

        <ul class="dropdown-menu user-menu" aria-labelledby="userDropdown">
            <li>
                <a class="dropdown-item" href="">
                    <i class="fa fa-user me-2"></i> <?php echo strtok($_SESSION['user_name'], ' ');?> (<?php echo $_SESSION['role']; ?>)
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="Admin/payment-details.php">
                    <i class="fa fa-credit-card"></i> Billing history
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="Admin/company-profile.php">
                    <i class="fa fa-cog me-2"></i> Settings
                </a>
            </li>

            <li><hr class="dropdown-divider"></li>

            <li>
                <a class="dropdown-item text-danger" href="logout.php">
                    <i class="fa fa-sign-out me-2"></i> Sign Out
                </a>
            </li>
        </ul>
        </div>
    </div>
</div>
</div>


				
            <div class="col-lg-12">
                <div class="card">
                    
                            
                        <div class="card-body">
		<!-- <hr> -->

		<div id="response" class="alert alert-success" style="display:none;">
			<a href="#" class="close" data-dismiss="alert">&times;</a>
			<div class="message"></div>
		</div>

		<form method="post" id="update_invoice">
			<input type="hidden" name="action" value="update_invoice">
			<input type="hidden" name="update_id" value="<?php echo $getID; ?>">
			
			<div class="row">
    <!-- LEFT SIDE -->
    <div id="info1" class="col-xl-6">

	            <!-- Invoice ID -->
            <div style="margin-bottom: 15px" class="col-xl-8 mb-3">
                <label class="form-label">Invoice Number</label>
                <div class="input-group">
                    <span class="input-group-addon">#<?php echo $invoice_prefix ?></span>
                    <input type="text" name="invoice_id" id="invoice_id"
                           class="form-control required"
                           placeholder="Invoice Number"
                           value="<?php echo $getID; ?>">
                </div>
            </div>
        
		<div class="row">
            <!-- Invoice Date -->
            <div style="margin-bottom: 15px" class="col-xl-6 mb-3">
                <label class="form-label">Invoice Date</label>
                <div class="input-group date" id="invoice_date">
                    <input type="text" class="form-control required" 
                           name="invoice_date" placeholder="Invoice Date"
                           data-date-format="<?php echo DATE_FORMAT ?>" value="<?php echo $invoice_date; ?>">
                    <span class="input-group-addon">
                        <span class="glyphicon glyphicon-calendar"></span>
                    </span>
                </div>
            </div>

            <!-- Due Date -->
            <div style="margin-bottom: 15px" class="col-xl-6 mb-3">
                <label class="form-label">Due Date</label>
                <div class="input-group date" id="invoice_due_date">
                    <input type="text" class="form-control required" 
                           name="invoice_due_date" placeholder="Due Date"
                           data-date-format="<?php echo DATE_FORMAT ?>" value="<?php echo $invoice_due_date; ?>">
                    <span class="input-group-addon">
                        <span class="glyphicon glyphicon-calendar"></span>
                    </span>
                </div>
            

			</div>

        </div>
    </div>
	<div class="col-xl-2"></div>

    <!-- RIGHT SIDE -->
    <div id="info1" class="col-xl-4">

        <div class="row">

            <!-- Invoice Type -->
            <div class="col-xl-6 mb-3">
                <span class="form-label">Invoice Type</span>
                <select style="margin-top: 5px;" name="invoice_type" id="invoice_type" class="form-control">
                    <option value="Invoice" <?php if($invoice_type === 'Invoice'){?>selected<?php } ?>>Invoice</option>
					<option value="Quote" <?php if($invoice_type === 'Quote'){?>selected<?php } ?>>Quote</option>
					<option value="Receipt" <?php if($invoice_type === 'Receipt'){?>selected<?php } ?>>Receipt</option>
                </select>
            </div>

            <!-- Invoice Status -->
            <div class="col-xl-6 mb-3">
                <span class="form-label">Status</span>
                <select  style="margin-top: 5px;"  name="invoice_status" id="invoice_status" class="form-control">
                    <option value="Open" <?php if($invoice_status === 'Open'){?>selected<?php } ?>>Open</option>
					<option value="Pending" <?php if($invoice_status === 'Pending'){?>selected<?php } ?>>Pending</option>
					<option value="Paid" <?php if($invoice_status === 'Paid'){?>selected<?php } ?>>Paid</option>
                </select>
            </div>

        </div>
    </div>
</div>

<div class="divider"></div>

<div class="row">

    <!-- LEFT: CUSTOMER INFORMATION -->
    <div style="margin-top: 25px;" class="col-xl-6">
        <div class="panel panel-default">
            <div class="panel-body">
                <h4>
                    <i class="fa fa-user text-primary"></i> 
                    Select Customer Information

					<span style="float:right;"><a href="#" class="select-customer" title="Add New Customer">
                    <img src="images/icon/add-client.png" width="32" height="32"></span>
                </a>
                </h4>

				
                
				
            </div>

            <div class="panel-body form-group">
                <div class="row">

                    <div class="col-xs-6">
                        <div class="form-group">
                            <input type="text" class="form-control margin-bottom copy-input required" name="customer_name" id="customer_name" placeholder="Customer Name" tabindex="1" value="<?php echo $customer_name; ?>">
                        </div>

                        <div class="form-group">
                            <input type="text" class="form-control margin-bottom copy-input required" name="customer_address_1" id="customer_address_1" placeholder="Address Line 1" tabindex="3" value="<?php echo $customer_address_1; ?>">
                        </div>

                        <div class="form-group">
                            <input type="text" class="form-control margin-bottom copy-input required" name="customer_town" id="customer_town" placeholder="Town / City" tabindex="5" value="<?php echo $customer_town; ?>">
                        </div>

                        <div class="form-group no-margin-bottom">
                            <input type="text" class="form-control copy-input" name="customer_postcode" id="customer_postcode" placeholder="Postcode" tabindex="7" value="<?php echo $customer_postcode; ?>">
                        </div>
                    </div>

                    <div class="col-xs-6">

                        <div class="form-group">
                            <div class="input-group margin-bottom">
                                <span class="input-group-addon"><i class="fa fa-envelope"></i></span>
                                <input type="email" class="form-control copy-input" name="customer_email" id="customer_email" placeholder="Email Address" tabindex="2" value="<?php echo $customer_email; ?>">
                            </div>
                        </div>

                        <div class="form-group">
                            <input type="text" class="form-control margin-bottom copy-input" name="customer_address_2" id="customer_address_2" placeholder="Address Line 2" tabindex="4" value="<?php echo $customer_address_2; ?>">
                        </div>

                        <div class="form-group">
                            <input type="text" class="form-control margin-bottom copy-input" name="customer_county" id="customer_county" placeholder="Country" tabindex="6" value="<?php echo $customer_county; ?>">
                        </div>

                        <div class="form-group no-margin-bottom">
                            <input type="text" class="form-control" name="customer_phone" id="customer_phone" placeholder="Phone Number" tabindex="8" value="<?php echo $customer_phone; ?>">
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- RIGHT: SHIPPING INFORMATION -->
    <div style="margin-top: 25px;"  class="col-xl-6">
        <div class="panel panel-default">
            <div class="panel-body">
                <h4>
                    <i class="fa fa-truck text-primary"></i> 
                    Shipping Information
                </h4>
            </div>

            <div class="panel-body form-group">
                <div class="row">

                    <div class="col-xs-6">

                        <div class="form-group">
                            <input type="text" class="form-control margin-bottom required" name="customer_name_ship" id="customer_name_ship" placeholder="Recipient Name" tabindex="9" value="<?php echo $customer_name_ship; ?>">
                        </div>

                        <div class="form-group">
                            <input type="text" class="form-control margin-bottom" name="customer_address_2_ship" id="customer_address_2_ship" placeholder="Address Line 2" tabindex="11" value="<?php echo $customer_address_2_ship; ?>">
                        </div>

                        <div class="form-group no-margin-bottom">
                            <input type="text" class="form-control" name="customer_county_ship" id="customer_county_ship" placeholder="Country" tabindex="13" value="<?php echo $customer_county_ship; ?>">
                        </div>

                    </div>

                    <div class="col-xs-6">

                        <div class="form-group">
                            <input type="text" class="form-control margin-bottom required" name="customer_address_1_ship" id="customer_address_1_ship" placeholder="Address Line 1" tabindex="10" value="<?php echo $customer_address_1_ship; ?>">
                        </div>

                        <div class="form-group">
                            <input type="text" class="form-control margin-bottom" name="customer_town_ship" id="customer_town_ship" placeholder="Town / City" tabindex="12" value="<?php echo $customer_town_ship; ?>">
                        </div>

                        <div class="form-group no-margin-bottom">
                            <input type="text" class="form-control" name="customer_postcode_ship" id="customer_postcode_ship" placeholder="Postcode" tabindex="14" value="<?php echo $customer_postcode_ship; ?>">
                        </div>

                    </div>

                </div>
            </div>

        </div>
    </div>

</div>
			<!-- / end client details section -->
			<div class="row mx-n24">
    <div id="" class="col-12">
        <div class="table-responsive">
            <table class="table " id="invoice_table">
             <thead>
					<tr>
					<th width="49%">
							<h5> Product&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</h5>
						</th>
						<th width="13%">
							<h5>Qty&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</h5>
						</th>
						<th width="18%">
							<h5>Price(<?php echo $currency ?>)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</h5>
						</th>
						
						<th width="20%">
							<h5>Sub Total(<?php echo $currency ?>)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</h5>
						</th>
						<th></th>
					</tr>
				</thead>

                <tbody>
<?php
$itemStmt = $mysqli->prepare("
    SELECT product, product_description, qty, price, subtotal
    FROM invoice_items
    WHERE invoice = ?
    ORDER BY item_order ASC
");
$itemStmt->bind_param("s", $getID);
$itemStmt->execute();
$result2 = $itemStmt->get_result();

if ($result2->num_rows > 0):
    while ($row = $result2->fetch_assoc()):
?>

<tr>
						<td class="text-right">
							
							<div class="input-group form-group-sm  no-margin-bottom">
								<div class="col-lg-8  col-xs-8">
									<input type="text" class="form-control form-group-sm item-input invoice_product" name="invoice_product[]" aria-describedby="sizing-addon1" placeholder="Enter or Select Product" value="<?= htmlspecialchars($row['product']) ?>">
									<textarea id="auto-resize-textarea" type="text" class="form-control form-group-sm item-input invoice_product_description" name="invoice_product_description[]" placeholder="Enter Product Description"><?= htmlspecialchars($row['product_description']) ?></textarea>
									
								</div>
								<span style="float:right; margin-right:; margin-left:" class="item-select"> <a href="#"><img style="width: 30px; height: 30px;" src="images/icon/add.png" ></a></span>
							</div>	
                            </div>
						</td>
						<td class="text-right">
							<div class="input-group input-group-sm no-margin-bottom">
								<input direction="ltr" type="text" class="form-control  invoice_product_qty calculate" name="invoice_product_qty[]" value="1" value="<?= $row['qty'] ?>">
							</div>
						</td>
						<td class="text-right">
							<div class="input-group input-group-sm  no-margin-bottom">
								
								<input type="text" class="form-control calculate invoice_product_price required" name="invoice_product_price[]" aria-describedby="sizing-addon1"  value="<?= $row['price'] ?>">
							</div>
						</td>
						
						<td class="text-right">
							<div class="input-group input-group-sm">
								
								<input type="text" class="form-control calculate-sub" name="invoice_product_sub[]" id="invoice_product_sub" aria-describedby="sizing-addon1" value="<?= $row['subtotal'] ?>" readonly>
							</div>
						</td>
						<td><a href="#" style="float:left;" class=" btn btn-danger btn-xs delete-row"><span class="glyphicon glyphicon-remove" aria-hidden="true"></span></a></td>
					</tr>

                    <?php
    endwhile;
else:
?>
<tr>
    <td colspan="5" class="text-center text-danger">
        No items found for this voucher
    </td>
</tr>
<?php endif; ?>


</tbody>

				
            </table>
			<div style="padding: 3px 3px"><a href="#" class=" add-row"><img src="images/icon/add-new.png" width="20px" height="20px"><span style="color: black; font-weight: 700;">  Add New</span></a></div>
        </div>
    </div>
</div>

	<div class="divider"></div>
	
<div class="row">

    <!-- LEFT SIDE: FORM INPUTS -->
    <div class="col-12 col-lg-8">

        <div class="row">
            <div class="col-md-5">
                <div class="form-group">
                    <label class="col-form-label">Created By</label>
                    <input type="text" class="form-control" name="created_by" readonly
                           value="<?php 
                           if (!isset($_SESSION['user_id'])) {
                               header('Location: login.php'); exit;
                           }
                           echo $_SESSION['user_name']; 
                           ?>">
                </div>
            </div>

            <div class="col-md-7">
                <div class="form-group invoice">
                    <label class="col-form-label">Notes</label>
                    <textarea class="form-control" name="invoice_notes"
                              placeholder="Additional Notes..."><?php echo $invoice_notes; ?></textarea>
                </div>
            </div>
        </div>

    </div>
    <!-- END LEFT SIDE -->


    <!-- RIGHT SIDE: INVOICE TOTALS -->
    <div class="col-12 col-lg-4">
        <div id="invoice_totals" class="p-3 border rounded" style="background:#f8f9fa;">

            <div class="row align-items-center justify-content-between mb-2">
                <label class="col-6" style="font-size: 13px;"><b>Subtotal (<?php echo $currency ?>)</b></label>
                <div class="col-6 text-end" style="font-size:15px;font-weight:600;">
                    <span class="invoice-sub-total">0.00</span>
                    <input type="hidden" id="invoice_subtotal" name="invoice_subtotal" value="<?php echo $invoice_subtotal; ?>">
                </div>
            </div>

            <div class="row align-items-center justify-content-between mb-2">
                <label class="col-6" style="font-size: 13px;"><b>Discount (<?php echo $currency ?>)</b></label>
                <div class="col-6 text-end">
                    <input type="text" class="form-control calculate discount"
                           name="invoicediscount" placeholder="0.00 or %" value="<?php echo $invoicediscount; ?>">
                </div>
            </div>

            <div class="row align-items-center justify-content-between mb-2">
                <label class="col-6" style="font-size: 13px;"><b>Shipping (<?php echo $currency ?>)</b></label>
                <div class="col-6 text-end">
                    <input type="text" class="form-control calculate shipping"
                           name="invoice_shipping" placeholder="0.00" value="<?php echo $invoice_shipping; ?>">
                </div>
            </div>

            <div class="row align-items-center justify-content-between mb-2">
                <label class="col-6" style="font-size:11px;">
                    <b>TAX/VAT (<?php echo $currency ?>)</b><br>
                    Remove TAX/VAT <input type="checkbox" class="remove_vat">
                </label>
                <div class="col-6 text-end" style="font-size:15px;font-weight:600;">
                    <span class="invoice-vat"
                    data-vat-amount="<?php echo $invoice_vat; ?>"
                    data-enable-vat="<?php echo ENABLE_VAT ?>"
                    data-vat-rate="<?php echo $vat_rate; ?>"
                    data-vat-method="<?php echo VAT_INCLUDED; ?>">
                    <?php echo number_format($invoice_vat, 2); ?>
                </span>
              <input type="hidden" name="invoice_vat" id="invoice_vat" value="<?php echo $invoice_vat; ?>">

         

                </div>
            </div>

            <div class="row align-items-center justify-content-between">
                <label class="col-6 text-primary" style="font-size:15px;"><b>Total (<?php echo $currency ?>)</b></label>
                <div class="col-6 text-end text-primary" style="font-size:17px;font-weight:900;">
                    <span class="invoice-total">0.00</span>
                    <input type="hidden" id="invoice_total" name="invoice_total" value="<?php echo $invoice_total; ?>">
                </div>
            </div>

        </div>
    </div>
    <!-- END RIGHT SIDE -->

</div>

<div class="divider"></div>


                          
								<div class="row mt-3">
    
    <!-- LEFT: CANCEL BUTTON -->
    <div class="col-6">
        <button type="button" class="btn btn-secondary w-auto float-left">
            Cancel
        </button>
    </div>

    <!-- RIGHT: SUBMIT BUTTON -->
    <div class="col-6 text-end">
        <input type="submit" 
               class="btn btn-primary w-auto float-right"
               value="Update Invoice"  data-loading-text="Updating..." id="action_edit_invoice">
    </div>

</div>

							
						
</form>					







			

		<div id="insert" class="modal fade">
		  <div class="modal-dialog">
		    <div class="modal-content">
		      <div class="modal-header">
		        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
		        <h4 class="modal-title">Select an item</h4>
		      </div>
		      <div class="table-responsive modal-body">
				<?php popProductsList(); ?>
		      </div>
		      <div class="modal-footer">
		        <button type="button" data-dismiss="modal" class="btn btn-primary" id="selected">Add</button>
				<button type="button" data-dismiss="modal" class="btn">Cancel</button>
		      </div>
		    </div><!-- /.modal-content -->
		  </div><!-- /.modal-dialog -->
		</div><!-- /.modal -->







             

 <!-- Plugin -->
 
   
    <script src="app-assets/js/plugin/swiper-bundle.min.js"></script>
    <script src="app-assets/js/plugin/jquery.mask.min.js"></script>
    <script src="app-assets/js/plugin/autocomplete.min.js"></script>
    <script src="app-assets/js/plugin/moment.min.js"></script>

    <!-- Layouts -->
    <script src="app-assets/js/layouts/header-search.js"></script>
    <script src="app-assets/js/layouts/sider.js"></script>
    <script src="app-assets/js/components/input-number.js"></script>

    <!-- Base -->
    <script src="app-assets/js/base/index.js"></script>
    <!-- Customizer -->
    <script src="app-assets/js/customizer.js"></script>

    <!-- Charts -->
    <script src="app-assets/js/plugin/apexcharts.min.js"></script>
    <script src="app-assets/js/charts/apex-chart.js"></script>

    <!-- Cards -->
    <script src="app-assets/js/cards/card-advance.js"></script>
    <script src="app-assets/js/cards/card-analytic.js"></script>
    <script src="app-assets/js/cards/card-statistic.js"></script>

    <!-- Pages -->
    <script src="app-assets/js/pages/dashboard-ecommerce.js"></script>

    <!-- Custom -->
    <script src="assets/js/main.js"></script> 


	<script> 
	const textarea = document.getElementById('auto-resize-textarea');

textarea.addEventListener('input', () => {
  textarea.style.height = 'auto'; // Reset height to recalculate
  textarea.style.height = textarea.scrollHeight + 'px'; // Set height based on scrollHeight
});

// Optional: Initial resize if content is pre-filled
textarea.style.height = 'auto';
textarea.style.height = textarea.scrollHeight + 'px';

//tax js
document.addEventListener("DOMContentLoaded", function () {
    let vatSpan = document.querySelector(".invoice-vat");
    let vatEnabled = vatSpan.dataset.enableVat; // 1 or 0

    let removeVatCheckbox = document.querySelector(".remove_vat");

    // If VAT was enabled originally → do NOT check "Remove VAT"
    removeVatCheckbox.checked = (vatEnabled == 0);

    // Trigger your VAT recalculation function
    removeVatCheckbox.dispatchEvent(new Event("change"));
});

</script>
</body>


</html>